﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


// APARATY !!

namespace NorthwindApp
{
    public partial class Form1 : Form
    {
        private string filtr;
        private CurrencyManager cm;
        private CurrencyManager cmZamowienia;
        public static NorthwindDataSet.EmployeesRow pracownikRekord;

        public Form1()
        {
            InitializeComponent();
            northwindDataSet1.EnforceConstraints = false;
            employeeTerritoriesTableAdapter1.Fill(northwindDataSet1.EmployeeTerritories);            
            shippersTableAdapter1.Fill(northwindDataSet1.Shippers);
            ordersTableAdapter1.Fill(northwindDataSet1.Orders);
            order_DetailsTableAdapter1.Fill(northwindDataSet1.Order_Details);
            employeesTableAdapter1.Fill(northwindDataSet1.Employees);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // Silna typizacja
            MessageBox.Show(northwindDataSet1.Employees[0].FirstName.ToString());            

            // Słaba typizacja
            MessageBox.Show(northwindDataSet1.Tables["Employees"].
                Rows[0]["FirstName"].ToString());
        }

        private void button2_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();

            for (int i = 0; i < northwindDataSet1.Shippers.Count; i++)
            {
                string dostawca =                    
                    northwindDataSet1.Shippers[i].CompanyName + " " +
                    northwindDataSet1.Shippers[i].Phone.ToString();

                listBox1.Items.Add(dostawca);                
            }

            // Silna typizacja
            //foreach (NorthwindDataSet.ShippersRow sdr in northwindDataSet1.Shippers.Rows)
            //{
            //    string dostawca =
            //        sdr.CompanyName.ToString() + " " +
            //        sdr.Phone.ToString();

            //    listBox2.Items.Add(dostawca);
            //}

            // Słaba typizacja
            //foreach (DataRow dr in northwindDataSet1.Shippers.Rows)
            //{
            //    string dostawca =
            //        dr["CompanyName"].ToString() + " " +
            //        dr["Phone"].ToString();

            //    listBox2.Items.Add(dostawca);
            //}
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                string[] temp = listBox1.SelectedItem.ToString().Split('(');
                textBox1.Text = temp[0].Remove(temp[0].Length - 1);
                textBox2.Text = '(' + temp[1];
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
                if (textBox1.Text.Length == 0 || textBox2.Text.Length == 0)
                    MessageBox.Show("Popraw dane dostawcy");
                else
                {
                    // Silna typizacja
                    NorthwindDataSet.ShippersRow WierszDoEdycji =
                        northwindDataSet1.Shippers.FindByShipperID(listBox1.SelectedIndex + 1);

                    WierszDoEdycji.CompanyName = textBox1.Text.ToString();
                    WierszDoEdycji.Phone = textBox2.Text.ToString();

                    // Jeśli znamy indeks wiersza to
                    // nie musimy korzystać z metody FindByID
                                        
                    northwindDataSet1.Shippers[listBox1.SelectedIndex].CompanyName =
                        textBox1.Text.ToString();
                    northwindDataSet1.Shippers[listBox1.SelectedIndex].Phone =
                        textBox2.Text.ToString();

                    // Słaba typizacja
                    string filtr = "ShipperID = " +
                        (listBox1.SelectedIndex + 1).ToString();
                    DataRow[] WierszeDoEdycji =
                        northwindDataSet1.Tables["Shippers"].Select(filtr);

                    WierszeDoEdycji[0]["CompanyName"] = textBox1.Text.ToString();
                    WierszeDoEdycji[0]["Phone"] = textBox2.Text.ToString();

                    northwindDataSet1.Tables["Shippers"].
                        Rows[listBox1.SelectedIndex]["CompanyName"] =
                        textBox1.Text.ToString();

                    northwindDataSet1.Tables["Shippers"].
                        Rows[listBox1.SelectedIndex]["Phone"] =
                        textBox2.Text.ToString();

                    northwindDataSet1.AcceptChanges();
                }

            // Odświeżenie danych
            button2_Click(sender, e);
        }                

        private void button3_Click(object sender, EventArgs e)
        {
            // Czy wpisany text ma długość > 0 ?
            if (textBox1.Text.Length == 0 || textBox2.Text.Length == 0)
                MessageBox.Show("Popraw dane dostawcy");
            else
            {
                try
                {
                    // Silna typizacja
                    NorthwindDataSet.ShippersRow NowyWiersz =
                         northwindDataSet1.Shippers.NewShippersRow();               

                    NowyWiersz.ShipperID = northwindDataSet1.Shippers.Last().ShipperID + 1;
                    NowyWiersz.CompanyName = textBox1.Text.ToString();
                    NowyWiersz.Phone = textBox2.Text.ToString();

                    northwindDataSet1.Shippers.Rows.Add(NowyWiersz);

                    // Kontrola stanu rekordu
                    MessageBox.Show(northwindDataSet1.Shippers.Last().RowState.ToString());

                    // Słaba typizacja
                    //DataRow NowyWiersz2 = 
                    //    northwindDataSet1.Tables["Shippers"].NewRow();

                    //Int32 liczbaWierszy = northwindDataSet1.Tables["Shippers"].Rows.Count;

                    //NowyWiersz2["ShipperID"] = 
                    //    (int)northwindDataSet1.Tables["Shippers"].Rows[liczbaWierszy - 1]["ShipperID"] + 1;
                    //NowyWiersz2["CompanyName"] = textBox1.Text.ToString();
                    //NowyWiersz2["Phone"] = textBox2.Text;
                    //northwindDataSet1.Tables["Shippers"].Rows.Add(NowyWiersz2);

                    // Potwierdzenie zmian w northwindDataSet1
                    northwindDataSet1.AcceptChanges();

                    // Kontrola stanu rekordu
                    MessageBox.Show(northwindDataSet1.Shippers.Last().RowState.ToString());

                    // Odświeżenie listy dostawców
                    button2_Click(sender, e);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Podczas modyfikacji danych wystąpił błąd: "
                        + ex.Message);
                }
            }
        }
  
        private void button5_Click(object sender, EventArgs e)
        {
            NorthwindDataSet.ShippersDataTable Tabela = northwindDataSet1.Shippers;

            listBox1.Items.Clear();

            foreach (NorthwindDataSet.ShippersRow WierszDoEdycji 
                in northwindDataSet1.Shippers.Rows)
            {
                if (checkBox1.Checked)
                    WierszDoEdycji.BeginEdit();

                WierszDoEdycji.CompanyName = WierszDoEdycji.CompanyName + " (Zmieniony)";

                string pozycja;
                if (WierszDoEdycji.HasVersion(DataRowVersion.Proposed))
                {
                    pozycja =
                        "Wersja oryginalna: "
                        + WierszDoEdycji[1, DataRowVersion.Original].ToString()
                        // WierszDoEdycji[northwindDataSet1.Shippers.CompanyNameColumn, 
                        // DataRowVersion.Original].ToString()
                        + ", wersja proponowana: "
                        + WierszDoEdycji[1, DataRowVersion.Proposed].ToString()
                        + ", wersja bieżąca: "
                        + WierszDoEdycji[1, DataRowVersion.Current].ToString();
                }
                else
                {
                    pozycja = "Wersja oryginalna: "
                        + WierszDoEdycji[1, DataRowVersion.Original].ToString()
                        + ", wersja bieżąca: "
                        + WierszDoEdycji[1, DataRowVersion.Current].ToString();
                }
                listBox1.Items.Add(pozycja);
                northwindDataSet1.RejectChanges();
            }                                    
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }

        private void button6_Click(object sender, EventArgs e)
        {            
            // Słaba typizacja                       
            DataTable dt = northwindDataSet1.Tables["Shippers"];
            dt.RowChanging += new DataRowChangeEventHandler(dt_RowChanging);            

            if (checkBox1.Checked)            
                dt.Rows[0].BeginEdit();
            
            try
            {
                dt.Rows[0]["Phone"] = "503 999 999";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                dt.Rows[0].CancelEdit();
            }                  
        }

        void dt_RowChanging(object sender, DataRowChangeEventArgs e)
        {
            if (e.Row["Phone"].ToString()[0] != '('
                || e.Row["Phone"].ToString()[4] != ')')
            {
                throw new Exception("Numer kierunkowy powinien być ujęty w nawiasy");
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            DataTable dt = northwindDataSet1.Tables["Shippers"];

            try
            {
                dt.Rows[0].EndEdit();            
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                dt.Rows[0].CancelEdit();
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                // Silna typizacja
                NorthwindDataSet.ShippersDataTable Tabela =
                    northwindDataSet1.Shippers;

                Tabela.ColumnChanged +=
                    new DataColumnChangeEventHandler(Tabela_ColumnChanged);

                NorthwindDataSet.ShippersRow WierszDoEdycji =
                    northwindDataSet1.Shippers[listBox1.SelectedIndex];

                WierszDoEdycji.BeginEdit();
                WierszDoEdycji.CompanyName = textBox1.Text.ToString();
                WierszDoEdycji.Phone = textBox2.Text.ToString();
                WierszDoEdycji.EndEdit();

                northwindDataSet1.AcceptChanges();

                button2_Click(sender, e);
            }           
        }

        void Tabela_ColumnChanged(object sender, DataColumnChangeEventArgs e)
        {
            if (e.Column.ColumnName ==
                northwindDataSet1.Shippers.CompanyNameColumn.ColumnName)
                if (e.ProposedValue.ToString() == "")
                {
                    MessageBox.Show("Nazwa dostawcy nie może być pusta.");
                    e.Row.CancelEdit();
                }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                // Silna typizacja                                
                foreach (NorthwindDataSet.ShippersRow sdr in northwindDataSet1.Shippers)
                {
                    if (sdr.CompanyName == textBox1.Text && sdr.Phone == textBox2.Text)
                        sdr.Delete();
                }
                
                // Słaba typizacja
                //foreach (DataRow dr in northwindDataSet1.Tables["Shippers"].Rows)
                //{
                //    if (dr["CompanyName"].ToString() == textBox1.Text
                //        && dr["Phone"].ToString() == textBox2.Text)
                //        dr.Delete();                    
                //}                                

                northwindDataSet1.AcceptChanges();
                button2_Click(sender, e);                
            }
            else
                MessageBox.Show("Nie wybrano rekordu");            
        }

        private void tabPage3_Enter(object sender, EventArgs e)
        {
            listView1.Items.Clear();       
            // Korzystamy z utworzonej kwerendy w celu pobrania
            // danych pracowników spełniających określone kryteria                             
            northwindDataSet1.EnforceConstraints = false;
            employeesTableAdapter1.FillByCitiName(northwindDataSet1.Employees, filtr);

            listView1.Sorting = SortOrder.Ascending;
            listView1.LabelEdit = true;
                        
            listView1.Columns.Add("Imię i nazwisko", -2, HorizontalAlignment.Center);                        
            listView1.Columns.Add("Stanowisko", -2, HorizontalAlignment.Left);
            listView1.Columns.Add("Miasto", -2, HorizontalAlignment.Left);
            listView1.Columns.Add("Data urodzenia", -2, HorizontalAlignment.Left);
            listView1.Columns.Add("Data zatrudnienia", -2, HorizontalAlignment.Left);
            listView1.Columns.Add("ID pracownika", -2, HorizontalAlignment.Center);

            ImageList listaIkon = new ImageList();
            listaIkon.ImageSize = new Size(85, 100);
            ImageConverter imageConverter = new ImageConverter();            

            int index = 0;
            ListViewItem elementListy;
            
            foreach (NorthwindDataSet.EmployeesRow edr in northwindDataSet1.Employees)
            {
                elementListy = new ListViewItem();                                
                elementListy.Text = edr.FirstName
                    + " " + edr.LastName;                
                
                elementListy.SubItems.Add(edr.Title);
                elementListy.SubItems.Add(edr.City);
                elementListy.SubItems.Add(edr.BirthDate.ToShortDateString());
                elementListy.SubItems.Add(edr.HireDate.ToShortDateString());
                elementListy.SubItems.Add(edr.EmployeeID.ToString());

                Bitmap zdjecie = (Bitmap)imageConverter.ConvertFrom(edr.Photo);
                System.IntPtr iconHandle = zdjecie.GetHicon();
                System.Drawing.Icon ikona = Icon.FromHandle(iconHandle);
                elementListy.ImageIndex = index;
                listaIkon.Images.Add(ikona);
            
                index++;
                listView1.Items.Add(elementListy);                
            }
            
            listView1.LargeImageList = listaIkon;           
            listView1.View = View.Tile; 
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            filtr = (textBox3.Text == "") ? null : textBox3.Text;
            //tabPage3_Enter(sender, e);
            //employeesBindingSource.Filter = "City Like '" + filtr + "%'";
            //employeesTableAdapter1.Fill(northwindDataSet1.Employees);
        }

        private void listView1_AfterLabelEdit(object sender, LabelEditEventArgs e)
        {
            if(e.Label == null || e.Label == "" || !e.Label.Contains(' '))
            {
                MessageBox.Show("Wpisz prawidłowe dane");
                e.CancelEdit = true;
                return;
            }
            string[] NoweImieNazwisko = e.Label.ToString().Split(' ');
                        
            int pracownikaID = Convert.ToInt32(listView1.SelectedItems[0].SubItems[5].Text);
            NorthwindDataSet.EmployeesRow edr = 
                northwindDataSet1.Employees.FindByEmployeeID(pracownikaID);
                        
            edr.FirstName = NoweImieNazwisko[0];
            edr.LastName = NoweImieNazwisko[1];

            employeesTableAdapter1.Update(edr);            

            // Odświeżenie danych
            tabPage3_Enter(sender, e);
        }

        private void usunRekordToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count == 0)
            {
                MessageBox.Show("Wybierz rekord do usunięcia");
                return;
            }

            int pracownikaID = Convert.ToInt32(listView1.SelectedItems[0].SubItems[5].Text);

            NorthwindDataSet.EmployeesRow edr = 
                northwindDataSet1.Employees.NewEmployeesRow();
            edr = northwindDataSet1.Employees.FindByEmployeeID(pracownikaID);

            try
            {
                //edr.Delete();
                //employeesTableAdapter1.Update(edr);
                //tabPage3_Enter(sender, e);

                // Wymuszenie więzów integralności
                northwindDataSet1.EnforceConstraints = true;

                // Czy usuwany pracownik jest przełożonym?
                DataRow[] podwladni =
                    edr.GetChildRows(northwindDataSet1.Relations["FK_Employees_Employees"]);
                if (podwladni.Length == 0)
                    edr.Delete();
                else
                {
                    MessageBox.Show("Nie można usunąć przełożonego. Najpierw usuń jego podwładnych");
                    return;
                }

                // Usunięcie rekordów z zachowaniem integralności danych
                employeeTerritoriesTableAdapter1.
                    Update(northwindDataSet1.EmployeeTerritories);
                order_DetailsTableAdapter1.Update(northwindDataSet1.Order_Details);
                ordersTableAdapter1.Update(northwindDataSet1.Orders);
                employeesTableAdapter1.Update(northwindDataSet1.Employees);
                tabPage3_Enter(sender, e);
            }
            catch (Exception ex)
            {
                MessageBox.Show("W trakcie usuwania rekordu wystąpił błąd: \n" + ex.Message);
                northwindDataSet1.EnforceConstraints = false;
            }            
        }

        private void dodajRekordToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Form2().ShowDialog();
            tabPage3_Enter(sender, e);
        }
        
        private void edytujRekordToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count == 0)
            {
                MessageBox.Show("Wybierz rekord do usunięcia");
                return;
            }

            int pracownikaID = Convert.ToInt32(listView1.SelectedItems[0].SubItems[5].Text);
            new Form2(pracownikaID).ShowDialog();
            tabPage3_Enter(sender, e);
        }       
    }
}
